### 实验名称

逻辑回归分析及实战

### 实验目的

1、掌握基于jupyter notebook工具的使用，python基本语法、pandas、numpy、matplotlib等模块应用；

2、掌握基于pandas、numpy、matplotlib的数据加载、数据预处理、数据特征分析、数据相关性分析、数据集划分等；

3、掌握j基于sklearn构建逻辑回归算法的模型构建、训练、分类预测及模型评估等过程。

### 实验背景

1、通过对电信用户的相关数据，分析数据的特征、字段、格式以及相关性等因素，了解影响电信用户流失的关键性因素。

2、通过对逻辑回归模型的构建、训练及预测，找出影响电信用户流失的类别。

### 实验原理

使用JupyterNotebook对数据进行处理和分析，涉及到python3的基础语法、pandas模块、numpy模块、matplotlib模块等python相关的数据分析库，各模块实现以下功能：

1，利用JupyterNotebook工具进行python3编程，数据读取、函数调用、显示图像数据；

2，通过pandas加载电信用户相关的数据WA\_Fn-UseC\_-Telco-Customer-Churn.csv；

3，实现数据缺失值判断、格式转换等数据预处理操作；

4，通过sklearn实例化逻辑回归模型，并对数据进行训练，评估训练结果。

### 实验环境

Ubuntu 18.04

Python 3.9

jupyter notebook 6.1.0

pandas 2.0.3

matplotlib 3.7.2

numpy 1.25.2

sklearn 1.4.1

### **建议课时**

2课时

### 实验步骤

#### 1、导入相关库

（1）、打开terminal终端，下载源数据

```markup
cd ~
wget --restrict-file-names=nocontrol http://10.90.3.2/HUP/DataMining/2024/04/WA_Fn-UseC_-Telco-Customer-Churn.csv
 
```

（2）、启动jupyter

```markup
jupyter notebook
```

（3）、新建python3文档

![线性00.jpg](./pic/线性00.jpg)

（4）、导入相关模块

```markup
# 导入数据分析需要的包
import pandas as pd
import numpy as np
# 可视化包
import matplotlib.pyplot as plt
%matplotlib inline
# 忽略警告信息
import warnings
warnings.filterwarnings('ignore')
# 显示中文
plt.rcParams["font.sans-serif"] = ["Microsoft YaHei"]
plt.rcParams["axes.unicode_minus"] = False

from sklearn.preprocessing import StandardScaler,LabelEncoder
from sklearn.linear_model import LogisticRegression          # 逻辑回归
from sklearn.metrics import precision_score, recall_score, f1_score,accuracy_score
from sklearn.metrics import confusion_matrix,classification_report
from sklearn.model_selection import GridSearchCV,train_test_split  # 网格搜索
```

#### 2、数据加载

使用Python的pandas模块进行数据加载，示例代码如下：

```markup
# 导入数据集
df=pd.read_csv('/home/ubuntu/WA_Fn-UseC_-Telco-Customer-Churn.csv')
# 查看数据
df.head(5)
```

![逻辑03.jpg](./pic/逻辑03.jpg)

```markup
# 查看数据基本情况
df.info()
```

![逻辑04.jpg](./pic/逻辑04.jpg)

#### 3、数据预处理

(1)、转换数据类型

```markup
#强制转换数字(包括字符串)
df['TotalCharges']=df['TotalCharges'].apply(pd.to_numeric,errors='coerce')
df['TotalCharges'].dtypes

# convert_numeric=True 表示强制转换数字（包括字符串），不可转换的值Nan
df['MonthlyCharges']=df['MonthlyCharges'].apply(pd.to_numeric,errors='coerce')
df['MonthlyCharges'].dtypes
# 输出结果
```

![逻辑05.jpg](./pic/逻辑05.jpg)

(2)、判断数据缺失值

```markup
# 查询缺失值
df.isnull().sum()
```

![逻辑06.jpg](./pic/逻辑06.jpg)

(3)、定位缺失值

```markup
# 定位缺失值所在行，查看具体情况
df[df['TotalCharges']!=df['TotalCharges']][['tenure','MonthlyCharges','TotalCharges']]
```

![逻辑07.jpg](./pic/逻辑07.jpg)

发现这11个用户tenure（入网时常）为0，推测是当月新入网用户。根据一般经验，用户即使在注册的当月流失，也需缴纳当月费用。因此将这11个用户入网时长改为1，将总消费额填充为月消费额，符合实际情况。

(4)、填充缺失值

```markup
#将总消费额填充为月消费额
# 把所有需要替换的行的索引值取出来，转换成列表形式
TC_list = df[df['TotalCharges'].isnull()].index.to_list()
# 开始一一对应去替换
df.loc[TC_list,'TotalCharges'] = df.loc[TC_list,'MonthlyCharges']
# 查看是否替换成功
df[df['tenure']==0][['tenure','MonthlyCharges','TotalCharges']]
```

![逻辑08.jpg](./pic/逻辑08.jpg)

```markup
# 将‘tenure’入网时长从0修改为1
df.loc[:,'tenure'].replace(to_replace=0,value=1,inplace=True)
```

(5)、替换标签值

```markup
#对Churn 列中的值 Yes和 No分别用 1和 0替换，方便后续处理
df['Churn'].replace( 'Yes', 1,inplace = True)
df['Churn'].replace( 'No',  0,inplace = True)
df['Churn'].head()
```

![逻辑09.jpg](./pic/逻辑09.jpg)

#### 4、数据特征分析

（1）、客户流失情况

```markup
# 查看总体客户流失情况
churnvalue = df["Churn"].value_counts()
labels = df["Churn"].value_counts().index
plt.pie(churnvalue,
        labels=["未流失","流失"],
        explode=(0.1,0),
        autopct='%.2f%%', 
        shadow=True,)
plt.title("客户流失率比例",size=24)
plt.show()
```

![逻辑10.jpg](./pic/逻辑10.jpg)

（2）、删除不必要特征列

```markup
# CustomerID表示每个客户的标识，对后续建模不影响，这里选择删除CustomerID列
CustomerID=df["customerID"]
df.drop("customerID",axis=1, inplace=True)
df.head()
```

![逻辑11.jpg](./pic/逻辑11.jpg)

（3）连续数据的特征列进行标准化处理

```markup
 # 实例化一个转换器类
scaler = StandardScaler(copy=False)
# 调用fit_transform，其作用是先拟合数据，然后转化它将其转化为标准形式
scaler.fit_transform(df[['tenure','MonthlyCharges','TotalCharges']])
#利用transform函数实现标准化，作用是通过找中心和缩放等实现标准化
df[['tenure','MonthlyCharges','TotalCharges']]=scaler.transform(df[['tenure','MonthlyCharges','TotalCharges']])
df[['tenure','MonthlyCharges','TotalCharges']].head()
```

![逻辑12.jpg](./pic/逻辑12.jpg)

(4) 离散数据的特征列进行one-hot独热编码

```markup
# 查看对象类型字段中存在的值
def uni(columnlabel):
    # unique函数去除其中重复的元素，返回唯一值
    print(columnlabel,"--" ,df[columnlabel].unique())
    
dfobject=df.select_dtypes(['object'])

df.replace(to_replace='No internet service', value='No', inplace=True)
df.replace(to_replace='No phone service', value='No', inplace=True)
#查看
for i in range(0,len(dfobject.columns)):
    uni(dfobject.columns[i])
 
```

![逻辑13.jpg](./pic/逻辑13.jpg)

```markup
# 编码转换 
def labelencode(columnlabel):
    df[columnlabel] = LabelEncoder().fit_transform(df[columnlabel])
    
for i in range(0,len(dfobject.columns)):
    labelencode(dfobject.columns[i])
    
for i in range(0,len(dfobject.columns)):
    uni(dfobject.columns[i])
```

![逻辑14.jpg](./pic/逻辑14.jpg)

#### 5、相关性分析

从下图可以直观看出，PhoneService 、gender这两个变量与churn目标变量相关性最弱。

```markup
plt.figure(figsize=(16,8))
df.corr()['Churn'].sort_values(ascending = False).plot(kind='bar')
plt.tick_params(labelsize=14)     # 设置坐标轴字体大小
plt.xticks(rotation=45)         # 设置x轴文字转向
plt.title("Correlations between Churn and variables",fontsize=20)
plt.show()
```

![逻辑15.jpg](./pic/逻辑15.jpg)

#### 6、划分数据集

```python
# 特征选取
dropFea = ['gender','PhoneService']
df.drop(dropFea, inplace=True, axis =1)
# 深拷贝
X=df.copy()
X.drop(['Churn'],axis=1, inplace=True)
y=df["Churn"]

# 将数据集分成训练集和测试集，比例为7:3
# test_size = 0.3, 表示30%的数据作为测试集合，
# 剩余70%的数据作为训练集；state=0在切分时进行数据重洗牌的标识位。
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state = 40)
print("原始训练集包含样本数量: ", len(X_train))
print("原始测试集包含样本数量:  ", len(X_test))
print("原始样本总数: ", len(X_train)+len(X_test))
```

![逻辑16.jpg](./pic/逻辑16.jpg)

#### 7、构建并训练模型

```markup
# 逻辑回归建模
model = LogisticRegression(solver='liblinear', penalty='l1')
model.fit(X_train, y_train)

# 用建好的模型model在测试集进行验证
predictions = model.predict(X_test)

# 评估模型
actual_score = accuracy_score(y_test, predictions)
print(actual_score)
```

0.78466

```markup
# 打印分类报告
print(classification_report(y_test,predictions))
```

![逻辑17.jpg](./pic/逻辑17.jpg)

### 实验总结

本项目主要内容是使用jupyterNotebook对电信用户数据进行分类预测，首先用pandas对数据合并后做类型转换、缺失值处理，其次将特征列于标签进行相关性分析，通过可视化库matplotlib将客户流失用饼状图显示，特征的相关性用柱形图显示，构建逻辑回归模型并训练模型，最后用分类报告对模型分类效果评估。通过实操能够熟悉逻辑回归的建模、训练和应用到数据分析的过程，加强学生对数据分析工具pandas、numpy以及matplotlib的理解，同时掌握基于sklearn库构建逻辑回归的分类算法，并将算法应用在实际的项目中。